///////////////////////////////////////////////////////////////////////////////////////
//
// MonoComm
//
// MonoComm private header with VAG defintions, kindly provided by VAG :)
//
// Put any discovered VAG-related constants and structs here, consider using VAG-COM Spy.
// Don't overfill with unused ones. Keep the grouping.
//
// 03/05/07		Hounddog	Sporadic DTC attribute
// 25/02/07		Hounddog	Errors recovering
// 09/02/07		Hounddog	Initial implementation
//

#ifndef VAG_COMM_H
#define VAG_COMM_H

#pragma warning(push)
#pragma warning(disable: 4200)

#pragma pack (push)
#pragma pack (1)

const DWORD VAG_CONNECT_BAUD_RATE	= 5;		// Connection baud rate
const DWORD VAG_DISCONNECT_TIMEOUT	= 1000;		// Inactivity timeout, ms (1010 works / 1020 doesn't)
const DWORD VAG_BREAK_TIMEOUT		= 40;		// Break timeout, ms

///////////////////////////////////////////////////////////////////////////////////////////
// Signatures

const BYTE VAG_SIG_BAUD_RATE_SYNCH	= 0x55;		// Baud rate synchronizer
const WORD VAG_SIG_MAGIC			= 0x8A01;	// VAG magic numbers
const BYTE VAG_SIG_MAGIC_ACK		= 0x75;		// VAG magic acknowledgement
const BYTE VAG_SIG_BLOCK_END		= 0x03;		// End of block

///////////////////////////////////////////////////////////////////////////////////////////
// Block type ids

const BYTE VAG_BTI_INFO_REQ		= 0x00;		// Info request
const BYTE VAG_BTI_INFO_RES		= 0xF6;		// Info response
const BYTE VAG_BTI_ACT_REQ		= 0x04;		// Actuators request
const BYTE VAG_BTI_ACT_RES		= 0xF5;		// Actuators response
const BYTE VAG_BTI_DTC_REQ		= 0x07;		// Diagnostic trouble codes reguest
const BYTE VAG_BTI_DTC_RES		= 0xFC;		// Diagnostic trouble codes response
const BYTE VAG_BTI_DTC_CLR		= 0x05;		// Diagnostic trouble codes clearing
const BYTE VAG_BTI_BS_REQ		= 0x11;		// Basic settings reguest
const BYTE VAG_BTI_BS_RES		= 0xF4;		// Basic settings response
const BYTE VAG_BTI_ACK			= 0x09;		// Acknowledgment
const BYTE VAG_BTI_ERROR		= 0x0A;		// Error
const BYTE VAG_BTI_COMM_END		= 0x06;		// End of communication

///////////////////////////////////////////////////////////////////////////////////////////
// Block header

struct VAG_BLOCK_HEADER
{
	BYTE bBlockSize;			// block size (including bBlockSize)
	BYTE bBlockIndex;			// block index
	BYTE bBlockTypeId;			// block type id
};

///////////////////////////////////////////////////////////////////////////////////////////
// Abstract block
//
// Any block starts from the block header.
// Generally block size is dynamic.

struct VAG_BLOCK
{
	VAG_BLOCK_HEADER blockheader;
};

///////////////////////////////////////////////////////////////////////////////////////////
// Info request block

struct VAG_BLOCK_INFO_REQ : VAG_BLOCK
{
};

///////////////////////////////////////////////////////////////////////////////////////////
// Info response block

struct VAG_BLOCK_INFO_RES : VAG_BLOCK
{
	CHAR acInfo[];		// Not NTS (sz)
};

///////////////////////////////////////////////////////////////////////////////////////////
// Actuator request block

struct VAG_BLOCK_ACT_REQ : VAG_BLOCK
{
	BYTE bUnknown;
};

///////////////////////////////////////////////////////////////////////////////////////////
// Actuator response block

struct VAG_BLOCK_ACT_RES : VAG_BLOCK
{
	WORD wActuatorCode;		// Big endian
};

///////////////////////////////////////////////////////////////////////////////////////////
// Diagnostic trouble codes request block

struct VAG_BLOCK_DTC_REQ : VAG_BLOCK
{
};

///////////////////////////////////////////////////////////////////////////////////////////
// Diagnostic trouble codes response block

struct VAG_BLOCK_DTC_RES : VAG_BLOCK
{
	WORD wCode;				// Big endian
	BYTE bSubCode  : 7;
	BYTE fSporadic : 1;
};

///////////////////////////////////////////////////////////////////////////////////////////
// Diagnostic trouble codes clearing block

struct VAG_BLOCK_DTC_CLR : VAG_BLOCK
{
};

///////////////////////////////////////////////////////////////////////////////////////////
// Basic settings request block

struct VAG_BLOCK_BS_REQ : VAG_BLOCK 
{
};

///////////////////////////////////////////////////////////////////////////////////////////
// Basic settings response block

struct VAG_BLOCK_BS_RES : VAG_BLOCK 
{
	BYTE abZone[];
};

///////////////////////////////////////////////////////////////////////////////////////////
// Acknowledgment block

struct VAG_BLOCK_ACK : VAG_BLOCK 
{
};

///////////////////////////////////////////////////////////////////////////////////////////
// Error block

struct VAG_BLOCK_ERROR : VAG_BLOCK 
{
	BYTE bRequestIndex;		// Request block index
};

///////////////////////////////////////////////////////////////////////////////////////////
// End of communication block

struct VAG_BLOCK_COMM_END : VAG_BLOCK 
{
};

#pragma pack (pop)

#pragma warning(pop)

#endif
